<?php
function hex2rgb($hex, $rgb) {
	if ($hex[0] == '#') {
		$hex = substr($hex, 1);
	}

	if (strlen($hex) == 6) {
		list($r, $g, $b) = array(
			$hex[0] . $hex[1],
			$hex[2] . $hex[3],
			$hex[4] . $hex[5]);
	} elseif (strlen($hex) == 3) {
		list($r, $g, $b) = array($hex[0], $hex[1], $hex[2]);
	} else {
		return false;
	}

	$r = hexdec($r); $g = hexdec($g); $b = hexdec($b);

	if ($rgb == 'r') {
		return $r;
	} elseif ($rgb == 'g') {
		return $g;
	} elseif ($rgb == 'b') {
		return $b;
	}
}

$hex = addslashes($_GET['hex']);

$img_size = imagecreate(50, 12);
$color = imagecolorallocate($img_size, hex2rgb($hex, 'r'), hex2rgb($hex, 'g'), hex2rgb($hex, 'b'));

imagefill($img_size, 0, 0, $color);

header("Content-type:image/jpeg");
imagejpeg($img_size);
?>